package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcFlowLogId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFlowLogsRequest(flowLogIds: Iterable[VpcFlowLogId]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest = {
    import DeleteFlowLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest
      .builder()
      .flowLogIds(flowLogIds.map { item =>
        VpcFlowLogId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFlowLogsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteFlowLogsRequest.wrap(buildAwsValue())
}
object DeleteFlowLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFlowLogsRequest =
      zio.aws.ec2.model.DeleteFlowLogsRequest(flowLogIds)
    def flowLogIds: List[VpcFlowLogId]
    def getFlowLogIds: ZIO[Any, Nothing, List[VpcFlowLogId]] =
      ZIO.succeed(flowLogIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest
  ) extends zio.aws.ec2.model.DeleteFlowLogsRequest.ReadOnly {
    override val flowLogIds: List[VpcFlowLogId] = impl
      .flowLogIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.VpcFlowLogId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest
  ): zio.aws.ec2.model.DeleteFlowLogsRequest.ReadOnly = new Wrapper(impl)
}
