package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse(
    localGatewayRouteTableVirtualInterfaceGroupAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse = {
    import CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
      .builder()
      .optionallyWith(
        localGatewayRouteTableVirtualInterfaceGroupAssociation.map(value =>
          value.buildAwsValue()
        )
      )(_.localGatewayRouteTableVirtualInterfaceGroupAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.ReadOnly =
    zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
      .wrap(buildAwsValue())
}
object CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse =
      zio.aws.ec2.model
        .CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse(
          localGatewayRouteTableVirtualInterfaceGroupAssociation.map(value =>
            value.asEditable
          )
        )
    def localGatewayRouteTableVirtualInterfaceGroupAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
    ]
    def getLocalGatewayRouteTableVirtualInterfaceGroupAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "localGatewayRouteTableVirtualInterfaceGroupAssociation",
      localGatewayRouteTableVirtualInterfaceGroupAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
  ) extends zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.ReadOnly {
    override val localGatewayRouteTableVirtualInterfaceGroupAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.localGatewayRouteTableVirtualInterfaceGroupAssociation()
      )
      .map(value =>
        zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
  ): zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
