package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  PlacementGroupArn,
  OutpostArn,
  DateTime,
  Integer
}
import scala.jdk.CollectionConverters._
final case class CreateCapacityReservationRequest(
    clientToken: Optional[String] = Optional.Absent,
    instanceType: String,
    instancePlatform: zio.aws.ec2.model.CapacityReservationInstancePlatform,
    availabilityZone: Optional[String] = Optional.Absent,
    availabilityZoneId: Optional[String] = Optional.Absent,
    tenancy: Optional[zio.aws.ec2.model.CapacityReservationTenancy] =
      Optional.Absent,
    instanceCount: Integer,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    ephemeralStorage: Optional[Boolean] = Optional.Absent,
    endDate: Optional[DateTime] = Optional.Absent,
    endDateType: Optional[zio.aws.ec2.model.EndDateType] = Optional.Absent,
    instanceMatchCriteria: Optional[zio.aws.ec2.model.InstanceMatchCriteria] =
      Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    outpostArn: Optional[OutpostArn] = Optional.Absent,
    placementGroupArn: Optional[PlacementGroupArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest = {
    import CreateCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .instanceType(instanceType: java.lang.String)
      .instancePlatform(instancePlatform.unwrap)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .instanceCount(instanceCount: java.lang.Integer)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(ephemeralStorage.map(value => value: java.lang.Boolean))(
        _.ephemeralStorage
      )
      .optionallyWith(endDate.map(value => DateTime.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(endDateType.map(value => value.unwrap))(_.endDateType)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        outpostArn.map(value => OutpostArn.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .optionallyWith(
        placementGroupArn.map(value =>
          PlacementGroupArn.unwrap(value): java.lang.String
        )
      )(_.placementGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCapacityReservationRequest.ReadOnly =
    zio.aws.ec2.model.CreateCapacityReservationRequest.wrap(buildAwsValue())
}
object CreateCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCapacityReservationRequest =
      zio.aws.ec2.model.CreateCapacityReservationRequest(
        clientToken.map(value => value),
        instanceType,
        instancePlatform,
        availabilityZone.map(value => value),
        availabilityZoneId.map(value => value),
        tenancy.map(value => value),
        instanceCount,
        ebsOptimized.map(value => value),
        ephemeralStorage.map(value => value),
        endDate.map(value => value),
        endDateType.map(value => value),
        instanceMatchCriteria.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outpostArn.map(value => value),
        placementGroupArn.map(value => value)
      )
    def clientToken: Optional[String]
    def instanceType: String
    def instancePlatform: zio.aws.ec2.model.CapacityReservationInstancePlatform
    def availabilityZone: Optional[String]
    def availabilityZoneId: Optional[String]
    def tenancy: Optional[zio.aws.ec2.model.CapacityReservationTenancy]
    def instanceCount: Integer
    def ebsOptimized: Optional[Boolean]
    def ephemeralStorage: Optional[Boolean]
    def endDate: Optional[DateTime]
    def endDateType: Optional[zio.aws.ec2.model.EndDateType]
    def instanceMatchCriteria: Optional[zio.aws.ec2.model.InstanceMatchCriteria]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def outpostArn: Optional[OutpostArn]
    def placementGroupArn: Optional[PlacementGroupArn]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getInstancePlatform: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = ZIO.succeed(instancePlatform)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getTenancy
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationTenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(instanceCount)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getEphemeralStorage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getEndDateType: ZIO[Any, AwsError, zio.aws.ec2.model.EndDateType] =
      AwsError.unwrapOptionField("endDateType", endDateType)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getOutpostArn: ZIO[Any, AwsError, OutpostArn] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getPlacementGroupArn: ZIO[Any, AwsError, PlacementGroupArn] =
      AwsError.unwrapOptionField("placementGroupArn", placementGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest
  ) extends zio.aws.ec2.model.CreateCapacityReservationRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val instanceType: String = impl.instanceType(): String
    override val instancePlatform
        : zio.aws.ec2.model.CapacityReservationInstancePlatform =
      zio.aws.ec2.model.CapacityReservationInstancePlatform
        .wrap(impl.instancePlatform())
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val availabilityZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneId())
      .map(value => value: String)
    override val tenancy
        : Optional[zio.aws.ec2.model.CapacityReservationTenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value => zio.aws.ec2.model.CapacityReservationTenancy.wrap(value))
    override val instanceCount: Integer = impl.instanceCount(): Integer
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val ephemeralStorage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ephemeralStorage())
      .map(value => value: Boolean)
    override val endDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val endDateType: Optional[zio.aws.ec2.model.EndDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDateType())
        .map(value => zio.aws.ec2.model.EndDateType.wrap(value))
    override val instanceMatchCriteria
        : Optional[zio.aws.ec2.model.InstanceMatchCriteria] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMatchCriteria())
        .map(value => zio.aws.ec2.model.InstanceMatchCriteria.wrap(value))
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val outpostArn: Optional[OutpostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => zio.aws.ec2.model.primitives.OutpostArn(value))
    override val placementGroupArn: Optional[PlacementGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementGroupArn())
        .map(value => zio.aws.ec2.model.primitives.PlacementGroupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest
  ): zio.aws.ec2.model.CreateCapacityReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
