package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CloudWatchLogGroupArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchLogOptionsSpecification(
    logEnabled: Optional[Boolean] = Optional.Absent,
    logGroupArn: Optional[CloudWatchLogGroupArn] = Optional.Absent,
    logOutputFormat: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CloudWatchLogOptionsSpecification = {
    import CloudWatchLogOptionsSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CloudWatchLogOptionsSpecification
      .builder()
      .optionallyWith(logEnabled.map(value => value: java.lang.Boolean))(
        _.logEnabled
      )
      .optionallyWith(
        logGroupArn.map(value =>
          CloudWatchLogGroupArn.unwrap(value): java.lang.String
        )
      )(_.logGroupArn)
      .optionallyWith(logOutputFormat.map(value => value: java.lang.String))(
        _.logOutputFormat
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CloudWatchLogOptionsSpecification.ReadOnly =
    zio.aws.ec2.model.CloudWatchLogOptionsSpecification.wrap(buildAwsValue())
}
object CloudWatchLogOptionsSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CloudWatchLogOptionsSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CloudWatchLogOptionsSpecification =
      zio.aws.ec2.model.CloudWatchLogOptionsSpecification(
        logEnabled.map(value => value),
        logGroupArn.map(value => value),
        logOutputFormat.map(value => value)
      )
    def logEnabled: Optional[Boolean]
    def logGroupArn: Optional[CloudWatchLogGroupArn]
    def logOutputFormat: Optional[String]
    def getLogEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("logEnabled", logEnabled)
    def getLogGroupArn: ZIO[Any, AwsError, CloudWatchLogGroupArn] =
      AwsError.unwrapOptionField("logGroupArn", logGroupArn)
    def getLogOutputFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logOutputFormat", logOutputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CloudWatchLogOptionsSpecification
  ) extends zio.aws.ec2.model.CloudWatchLogOptionsSpecification.ReadOnly {
    override val logEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.logEnabled())
      .map(value => value: Boolean)
    override val logGroupArn: Optional[CloudWatchLogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logGroupArn())
        .map(value => zio.aws.ec2.model.primitives.CloudWatchLogGroupArn(value))
    override val logOutputFormat: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logOutputFormat())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CloudWatchLogOptionsSpecification
  ): zio.aws.ec2.model.CloudWatchLogOptionsSpecification.ReadOnly = new Wrapper(
    impl
  )
}
