package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  OutpostArn,
  PlacementGroupArn,
  MillisecondDateTime,
  DateTime,
  Integer
}
import scala.jdk.CollectionConverters._
final case class CapacityReservation(
    capacityReservationId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    capacityReservationArn: Optional[String] = Optional.Absent,
    availabilityZoneId: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    instancePlatform: Optional[
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    tenancy: Optional[zio.aws.ec2.model.CapacityReservationTenancy] =
      Optional.Absent,
    totalInstanceCount: Optional[Integer] = Optional.Absent,
    availableInstanceCount: Optional[Integer] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    ephemeralStorage: Optional[Boolean] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.CapacityReservationState] =
      Optional.Absent,
    startDate: Optional[MillisecondDateTime] = Optional.Absent,
    endDate: Optional[DateTime] = Optional.Absent,
    endDateType: Optional[zio.aws.ec2.model.EndDateType] = Optional.Absent,
    instanceMatchCriteria: Optional[zio.aws.ec2.model.InstanceMatchCriteria] =
      Optional.Absent,
    createDate: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    outpostArn: Optional[OutpostArn] = Optional.Absent,
    capacityReservationFleetId: Optional[String] = Optional.Absent,
    placementGroupArn: Optional[PlacementGroupArn] = Optional.Absent,
    capacityAllocations: Optional[
      Iterable[zio.aws.ec2.model.CapacityAllocation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservation = {
    import CapacityReservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservation
      .builder()
      .optionallyWith(
        capacityReservationId.map(value => value: java.lang.String)
      )(_.capacityReservationId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        capacityReservationArn.map(value => value: java.lang.String)
      )(_.capacityReservationArn)
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instancePlatform.map(value => value.unwrap))(
        _.instancePlatform
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        totalInstanceCount.map(value => value: java.lang.Integer)
      )(_.totalInstanceCount)
      .optionallyWith(
        availableInstanceCount.map(value => value: java.lang.Integer)
      )(_.availableInstanceCount)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(ephemeralStorage.map(value => value: java.lang.Boolean))(
        _.ephemeralStorage
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        startDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDate)
      .optionallyWith(endDate.map(value => DateTime.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(endDateType.map(value => value.unwrap))(_.endDateType)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(createDate.map(value => DateTime.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        outpostArn.map(value => OutpostArn.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .optionallyWith(
        capacityReservationFleetId.map(value => value: java.lang.String)
      )(_.capacityReservationFleetId)
      .optionallyWith(
        placementGroupArn.map(value =>
          PlacementGroupArn.unwrap(value): java.lang.String
        )
      )(_.placementGroupArn)
      .optionallyWith(
        capacityAllocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityAllocations)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservation.ReadOnly =
    zio.aws.ec2.model.CapacityReservation.wrap(buildAwsValue())
}
object CapacityReservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservation =
      zio.aws.ec2.model.CapacityReservation(
        capacityReservationId.map(value => value),
        ownerId.map(value => value),
        capacityReservationArn.map(value => value),
        availabilityZoneId.map(value => value),
        instanceType.map(value => value),
        instancePlatform.map(value => value),
        availabilityZone.map(value => value),
        tenancy.map(value => value),
        totalInstanceCount.map(value => value),
        availableInstanceCount.map(value => value),
        ebsOptimized.map(value => value),
        ephemeralStorage.map(value => value),
        state.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        endDateType.map(value => value),
        instanceMatchCriteria.map(value => value),
        createDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outpostArn.map(value => value),
        capacityReservationFleetId.map(value => value),
        placementGroupArn.map(value => value),
        capacityAllocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityReservationId: Optional[String]
    def ownerId: Optional[String]
    def capacityReservationArn: Optional[String]
    def availabilityZoneId: Optional[String]
    def instanceType: Optional[String]
    def instancePlatform
        : Optional[zio.aws.ec2.model.CapacityReservationInstancePlatform]
    def availabilityZone: Optional[String]
    def tenancy: Optional[zio.aws.ec2.model.CapacityReservationTenancy]
    def totalInstanceCount: Optional[Integer]
    def availableInstanceCount: Optional[Integer]
    def ebsOptimized: Optional[Boolean]
    def ephemeralStorage: Optional[Boolean]
    def state: Optional[zio.aws.ec2.model.CapacityReservationState]
    def startDate: Optional[MillisecondDateTime]
    def endDate: Optional[DateTime]
    def endDateType: Optional[zio.aws.ec2.model.EndDateType]
    def instanceMatchCriteria: Optional[zio.aws.ec2.model.InstanceMatchCriteria]
    def createDate: Optional[DateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def outpostArn: Optional[OutpostArn]
    def capacityReservationFleetId: Optional[String]
    def placementGroupArn: Optional[PlacementGroupArn]
    def capacityAllocations
        : Optional[List[zio.aws.ec2.model.CapacityAllocation.ReadOnly]]
    def getCapacityReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCapacityReservationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("capacityReservationArn", capacityReservationArn)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstancePlatform: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = AwsError.unwrapOptionField("instancePlatform", instancePlatform)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getTenancy
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationTenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getTotalInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalInstanceCount", totalInstanceCount)
    def getAvailableInstanceCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("availableInstanceCount", availableInstanceCount)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getEphemeralStorage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationState] =
      AwsError.unwrapOptionField("state", state)
    def getStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getEndDateType: ZIO[Any, AwsError, zio.aws.ec2.model.EndDateType] =
      AwsError.unwrapOptionField("endDateType", endDateType)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getCreateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOutpostArn: ZIO[Any, AwsError, OutpostArn] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getCapacityReservationFleetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetId",
        capacityReservationFleetId
      )
    def getPlacementGroupArn: ZIO[Any, AwsError, PlacementGroupArn] =
      AwsError.unwrapOptionField("placementGroupArn", placementGroupArn)
    def getCapacityAllocations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CapacityAllocation.ReadOnly
    ]] = AwsError.unwrapOptionField("capacityAllocations", capacityAllocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservation
  ) extends zio.aws.ec2.model.CapacityReservation.ReadOnly {
    override val capacityReservationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val capacityReservationArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationArn())
        .map(value => value: String)
    override val availabilityZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneId())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val instancePlatform
        : Optional[zio.aws.ec2.model.CapacityReservationInstancePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instancePlatform())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationInstancePlatform.wrap(value)
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val tenancy
        : Optional[zio.aws.ec2.model.CapacityReservationTenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value => zio.aws.ec2.model.CapacityReservationTenancy.wrap(value))
    override val totalInstanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalInstanceCount())
      .map(value => value: Integer)
    override val availableInstanceCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableInstanceCount())
        .map(value => value: Integer)
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val ephemeralStorage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ephemeralStorage())
      .map(value => value: Boolean)
    override val state: Optional[zio.aws.ec2.model.CapacityReservationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.CapacityReservationState.wrap(value))
    override val startDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val endDateType: Optional[zio.aws.ec2.model.EndDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDateType())
        .map(value => zio.aws.ec2.model.EndDateType.wrap(value))
    override val instanceMatchCriteria
        : Optional[zio.aws.ec2.model.InstanceMatchCriteria] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMatchCriteria())
        .map(value => zio.aws.ec2.model.InstanceMatchCriteria.wrap(value))
    override val createDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val outpostArn: Optional[OutpostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => zio.aws.ec2.model.primitives.OutpostArn(value))
    override val capacityReservationFleetId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationFleetId())
        .map(value => value: String)
    override val placementGroupArn: Optional[PlacementGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementGroupArn())
        .map(value => zio.aws.ec2.model.primitives.PlacementGroupArn(value))
    override val capacityAllocations
        : Optional[List[zio.aws.ec2.model.CapacityAllocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityAllocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CapacityAllocation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservation
  ): zio.aws.ec2.model.CapacityReservation.ReadOnly = new Wrapper(impl)
}
