package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcEndpointId, VpcEndpointServiceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AcceptVpcEndpointConnectionsRequest(
    serviceId: VpcEndpointServiceId,
    vpcEndpointIds: Iterable[VpcEndpointId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest = {
    import AcceptVpcEndpointConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest
      .builder()
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .vpcEndpointIds(vpcEndpointIds.map { item =>
        VpcEndpointId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest.wrap(buildAwsValue())
}
object AcceptVpcEndpointConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest =
      zio.aws.ec2.model
        .AcceptVpcEndpointConnectionsRequest(serviceId, vpcEndpointIds)
    def serviceId: VpcEndpointServiceId
    def vpcEndpointIds: List[VpcEndpointId]
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getVpcEndpointIds: ZIO[Any, Nothing, List[VpcEndpointId]] =
      ZIO.succeed(vpcEndpointIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest
  ) extends zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest.ReadOnly {
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val vpcEndpointIds: List[VpcEndpointId] = impl
      .vpcEndpointIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.VpcEndpointId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest
  ): zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
