package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayAttachmentResourceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType
}
object TransitGatewayAttachmentResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType
  ): zio.aws.ec2.model.TransitGatewayAttachmentResourceType = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.VPC =>
      val r = vpc
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.VPN =>
      val r = vpn
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.DIRECT_CONNECT_GATEWAY =>
      val r = `direct-connect-gateway`
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.CONNECT =>
      val r = connect
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.PEERING =>
      val r = peering
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.TGW_PEERING =>
      val r = `tgw-peering`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayAttachmentResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object vpc
      extends zio.aws.ec2.model.TransitGatewayAttachmentResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.VPC
  }
  case object vpn
      extends zio.aws.ec2.model.TransitGatewayAttachmentResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.VPN
  }
  case object `direct-connect-gateway`
      extends zio.aws.ec2.model.TransitGatewayAttachmentResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.DIRECT_CONNECT_GATEWAY
  }
  case object connect
      extends zio.aws.ec2.model.TransitGatewayAttachmentResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.CONNECT
  }
  case object peering
      extends zio.aws.ec2.model.TransitGatewayAttachmentResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.PEERING
  }
  case object `tgw-peering`
      extends zio.aws.ec2.model.TransitGatewayAttachmentResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType.TGW_PEERING
  }
}
