package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, SubnetCidrReservationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubnetCidrReservation(
    subnetCidrReservationId: Optional[SubnetCidrReservationId] =
      Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    cidr: Optional[String] = Optional.Absent,
    reservationType: Optional[zio.aws.ec2.model.SubnetCidrReservationType] =
      Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SubnetCidrReservation = {
    import SubnetCidrReservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SubnetCidrReservation
      .builder()
      .optionallyWith(
        subnetCidrReservationId.map(value =>
          SubnetCidrReservationId.unwrap(value): java.lang.String
        )
      )(_.subnetCidrReservationId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(reservationType.map(value => value.unwrap))(
        _.reservationType
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SubnetCidrReservation.ReadOnly =
    zio.aws.ec2.model.SubnetCidrReservation.wrap(buildAwsValue())
}
object SubnetCidrReservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SubnetCidrReservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SubnetCidrReservation =
      zio.aws.ec2.model.SubnetCidrReservation(
        subnetCidrReservationId.map(value => value),
        subnetId.map(value => value),
        cidr.map(value => value),
        reservationType.map(value => value),
        ownerId.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subnetCidrReservationId: Optional[SubnetCidrReservationId]
    def subnetId: Optional[SubnetId]
    def cidr: Optional[String]
    def reservationType: Optional[zio.aws.ec2.model.SubnetCidrReservationType]
    def ownerId: Optional[String]
    def description: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getSubnetCidrReservationId
        : ZIO[Any, AwsError, SubnetCidrReservationId] = AwsError
      .unwrapOptionField("subnetCidrReservationId", subnetCidrReservationId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getReservationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.SubnetCidrReservationType] =
      AwsError.unwrapOptionField("reservationType", reservationType)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SubnetCidrReservation
  ) extends zio.aws.ec2.model.SubnetCidrReservation.ReadOnly {
    override val subnetCidrReservationId: Optional[SubnetCidrReservationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetCidrReservationId())
        .map(value =>
          zio.aws.ec2.model.primitives.SubnetCidrReservationId(value)
        )
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val reservationType
        : Optional[zio.aws.ec2.model.SubnetCidrReservationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservationType())
        .map(value => zio.aws.ec2.model.SubnetCidrReservationType.wrap(value))
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SubnetCidrReservation
  ): zio.aws.ec2.model.SubnetCidrReservation.ReadOnly = new Wrapper(impl)
}
