package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupId,
  PrefixListResourceId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityGroupRuleRequest(
    ipProtocol: Optional[String] = Optional.Absent,
    fromPort: Optional[Integer] = Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent,
    cidrIpv4: Optional[String] = Optional.Absent,
    cidrIpv6: Optional[String] = Optional.Absent,
    prefixListId: Optional[PrefixListResourceId] = Optional.Absent,
    referencedGroupId: Optional[SecurityGroupId] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest = {
    import SecurityGroupRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest
      .builder()
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .optionallyWith(cidrIpv4.map(value => value: java.lang.String))(
        _.cidrIpv4
      )
      .optionallyWith(cidrIpv6.map(value => value: java.lang.String))(
        _.cidrIpv6
      )
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(
        referencedGroupId.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.referencedGroupId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly =
    zio.aws.ec2.model.SecurityGroupRuleRequest.wrap(buildAwsValue())
}
object SecurityGroupRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupRuleRequest =
      zio.aws.ec2.model.SecurityGroupRuleRequest(
        ipProtocol.map(value => value),
        fromPort.map(value => value),
        toPort.map(value => value),
        cidrIpv4.map(value => value),
        cidrIpv6.map(value => value),
        prefixListId.map(value => value),
        referencedGroupId.map(value => value),
        description.map(value => value)
      )
    def ipProtocol: Optional[String]
    def fromPort: Optional[Integer]
    def toPort: Optional[Integer]
    def cidrIpv4: Optional[String]
    def cidrIpv6: Optional[String]
    def prefixListId: Optional[PrefixListResourceId]
    def referencedGroupId: Optional[SecurityGroupId]
    def description: Optional[String]
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getCidrIpv4: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv4", cidrIpv4)
    def getCidrIpv6: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv6", cidrIpv6)
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getReferencedGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("referencedGroupId", referencedGroupId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest
  ) extends zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly {
    override val ipProtocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipProtocol())
      .map(value => value: String)
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
    override val cidrIpv4: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIpv4())
      .map(value => value: String)
    override val cidrIpv6: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIpv6())
      .map(value => value: String)
    override val prefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val referencedGroupId: Optional[SecurityGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referencedGroupId())
        .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleRequest
  ): zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly = new Wrapper(impl)
}
