package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevokeClientVpnIngressRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    targetNetworkCidr: String,
    accessGroupId: Optional[String] = Optional.Absent,
    revokeAllGroups: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest = {
    import RevokeClientVpnIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .targetNetworkCidr(targetNetworkCidr: java.lang.String)
      .optionallyWith(accessGroupId.map(value => value: java.lang.String))(
        _.accessGroupId
      )
      .optionallyWith(revokeAllGroups.map(value => value: java.lang.Boolean))(
        _.revokeAllGroups
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RevokeClientVpnIngressRequest.ReadOnly =
    zio.aws.ec2.model.RevokeClientVpnIngressRequest.wrap(buildAwsValue())
}
object RevokeClientVpnIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RevokeClientVpnIngressRequest =
      zio.aws.ec2.model.RevokeClientVpnIngressRequest(
        clientVpnEndpointId,
        targetNetworkCidr,
        accessGroupId.map(value => value),
        revokeAllGroups.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def targetNetworkCidr: String
    def accessGroupId: Optional[String]
    def revokeAllGroups: Optional[Boolean]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getTargetNetworkCidr: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetNetworkCidr)
    def getAccessGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessGroupId", accessGroupId)
    def getRevokeAllGroups: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("revokeAllGroups", revokeAllGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest
  ) extends zio.aws.ec2.model.RevokeClientVpnIngressRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val targetNetworkCidr: String = impl.targetNetworkCidr(): String
    override val accessGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accessGroupId())
      .map(value => value: String)
    override val revokeAllGroups: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.revokeAllGroups())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest
  ): zio.aws.ec2.model.RevokeClientVpnIngressRequest.ReadOnly = new Wrapper(
    impl
  )
}
