package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ResetImageAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.ResetImageAttributeName
}
object ResetImageAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ResetImageAttributeName
  ): zio.aws.ec2.model.ResetImageAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.ResetImageAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ResetImageAttributeName.LAUNCH_PERMISSION =>
      val r = launchPermission
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ResetImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResetImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ResetImageAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object launchPermission
      extends zio.aws.ec2.model.ResetImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResetImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ResetImageAttributeName.LAUNCH_PERMISSION
  }
}
