package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LocalStorage {
  def unwrap: software.amazon.awssdk.services.ec2.model.LocalStorage
}
object LocalStorage {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LocalStorage
  ): zio.aws.ec2.model.LocalStorage = value match {
    case software.amazon.awssdk.services.ec2.model.LocalStorage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LocalStorage.INCLUDED =>
      val r = included
      r
    case software.amazon.awssdk.services.ec2.model.LocalStorage.REQUIRED =>
      val r = required
      r
    case software.amazon.awssdk.services.ec2.model.LocalStorage.EXCLUDED =>
      val r = excluded
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.LocalStorage {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalStorage =
      software.amazon.awssdk.services.ec2.model.LocalStorage.UNKNOWN_TO_SDK_VERSION
  }
  case object included extends zio.aws.ec2.model.LocalStorage {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalStorage =
      software.amazon.awssdk.services.ec2.model.LocalStorage.INCLUDED
  }
  case object required extends zio.aws.ec2.model.LocalStorage {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalStorage =
      software.amazon.awssdk.services.ec2.model.LocalStorage.REQUIRED
  }
  case object excluded extends zio.aws.ec2.model.LocalStorage {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalStorage =
      software.amazon.awssdk.services.ec2.model.LocalStorage.EXCLUDED
  }
}
