package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{LocalGatewayId, ResourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LocalGatewayRouteTable(
    localGatewayRouteTableId: Optional[String] = Optional.Absent,
    localGatewayRouteTableArn: Optional[ResourceArn] = Optional.Absent,
    localGatewayId: Optional[LocalGatewayId] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable = {
    import LocalGatewayRouteTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable
      .builder()
      .optionallyWith(
        localGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        localGatewayRouteTableArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableArn)
      .optionallyWith(
        localGatewayId.map(value =>
          LocalGatewayId.unwrap(value): java.lang.String
        )
      )(_.localGatewayId)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly =
    zio.aws.ec2.model.LocalGatewayRouteTable.wrap(buildAwsValue())
}
object LocalGatewayRouteTable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGatewayRouteTable =
      zio.aws.ec2.model.LocalGatewayRouteTable(
        localGatewayRouteTableId.map(value => value),
        localGatewayRouteTableArn.map(value => value),
        localGatewayId.map(value => value),
        outpostArn.map(value => value),
        ownerId.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localGatewayRouteTableId: Optional[String]
    def localGatewayRouteTableArn: Optional[ResourceArn]
    def localGatewayId: Optional[LocalGatewayId]
    def outpostArn: Optional[String]
    def ownerId: Optional[String]
    def state: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLocalGatewayRouteTableId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
    def getLocalGatewayRouteTableArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("localGatewayRouteTableArn", localGatewayRouteTableArn)
    def getLocalGatewayId: ZIO[Any, AwsError, LocalGatewayId] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable
  ) extends zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly {
    override val localGatewayRouteTableId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableId())
        .map(value => value: String)
    override val localGatewayRouteTableArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val localGatewayId: Optional[LocalGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayId())
        .map(value => zio.aws.ec2.model.primitives.LocalGatewayId(value))
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable
  ): zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly = new Wrapper(impl)
}
