package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceLifecycle {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceLifecycle
}
object InstanceLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceLifecycle
  ): zio.aws.ec2.model.InstanceLifecycle = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceLifecycle.SPOT =>
      val r = spot
      r
    case software.amazon.awssdk.services.ec2.model.InstanceLifecycle.ON_DEMAND =>
      val r = `on-demand`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.InstanceLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceLifecycle =
      software.amazon.awssdk.services.ec2.model.InstanceLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object spot extends zio.aws.ec2.model.InstanceLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceLifecycle =
      software.amazon.awssdk.services.ec2.model.InstanceLifecycle.SPOT
  }
  case object `on-demand` extends zio.aws.ec2.model.InstanceLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceLifecycle =
      software.amazon.awssdk.services.ec2.model.InstanceLifecycle.ON_DEMAND
  }
}
