package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportClientVpnClientCertificateRevocationListRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    certificateRevocationList: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest = {
    import ImportClientVpnClientCertificateRevocationListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .certificateRevocationList(certificateRevocationList: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest.ReadOnly =
    zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
      .wrap(buildAwsValue())
}
object ImportClientVpnClientCertificateRevocationListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest =
      zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest(
        clientVpnEndpointId,
        certificateRevocationList
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def certificateRevocationList: String
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getCertificateRevocationList: ZIO[Any, Nothing, String] =
      ZIO.succeed(certificateRevocationList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
  ) extends zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val certificateRevocationList: String =
      impl.certificateRevocationList(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
  ): zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest.ReadOnly =
    new Wrapper(impl)
}
