package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExportClientVpnClientCertificateRevocationListRequest(
    clientVpnEndpointId: ClientVpnEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest = {
    import ExportClientVpnClientCertificateRevocationListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest.ReadOnly =
    zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest
      .wrap(buildAwsValue())
}
object ExportClientVpnClientCertificateRevocationListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest =
      zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest(
        clientVpnEndpointId
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest
  ) extends zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest
  ): zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest.ReadOnly =
    new Wrapper(impl)
}
