package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ClientVpnAssociationId,
  ClientVpnEndpointId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateClientVpnTargetNetworkRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    associationId: ClientVpnAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest = {
    import DisassociateClientVpnTargetNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .associationId(
        ClientVpnAssociationId.unwrap(associationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest
      .wrap(buildAwsValue())
}
object DisassociateClientVpnTargetNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest =
      zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest(
        clientVpnEndpointId,
        associationId
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def associationId: ClientVpnAssociationId
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getAssociationId: ZIO[Any, Nothing, ClientVpnAssociationId] =
      ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest
  ) extends zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val associationId: ClientVpnAssociationId =
      zio.aws.ec2.model.primitives.ClientVpnAssociationId(impl.associationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest
  ): zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
