package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayRouteTablesResponse(
    localGatewayRouteTables: Optional[
      Iterable[zio.aws.ec2.model.LocalGatewayRouteTable]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse = {
    import DescribeLocalGatewayRouteTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse
      .builder()
      .optionallyWith(
        localGatewayRouteTables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localGatewayRouteTables)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayRouteTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse =
      zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse(
        localGatewayRouteTables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def localGatewayRouteTables
        : Optional[List[zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly]]
    def nextToken: Optional[String]
    def getLocalGatewayRouteTables: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "localGatewayRouteTables",
      localGatewayRouteTables
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse
  ) extends zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly {
    override val localGatewayRouteTables
        : Optional[List[zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LocalGatewayRouteTable.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse
  ): zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly =
    new Wrapper(impl)
}
