package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceCreditSpecificationsResponse(
    instanceCreditSpecifications: Optional[
      Iterable[zio.aws.ec2.model.InstanceCreditSpecification]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse = {
    import DescribeInstanceCreditSpecificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse
      .builder()
      .optionallyWith(
        instanceCreditSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceCreditSpecifications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceCreditSpecificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse =
      zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse(
        instanceCreditSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceCreditSpecifications
        : Optional[List[zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly]]
    def nextToken: Optional[String]
    def getInstanceCreditSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceCreditSpecifications",
      instanceCreditSpecifications
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse
  ) extends zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.ReadOnly {
    override val instanceCreditSpecifications: Optional[
      List[zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCreditSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceCreditSpecification.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse
  ): zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.ReadOnly =
    new Wrapper(impl)
}
