package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ImportImageTaskId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImportImageTasksRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    importTaskIds: Optional[Iterable[ImportImageTaskId]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest = {
    import DescribeImportImageTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        importTaskIds.map(value =>
          value.map { item =>
            ImportImageTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.importTaskIds)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImportImageTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeImportImageTasksRequest.wrap(buildAwsValue())
}
object DescribeImportImageTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImportImageTasksRequest =
      zio.aws.ec2.model.DescribeImportImageTasksRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        importTaskIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def importTaskIds: Optional[List[ImportImageTaskId]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getImportTaskIds: ZIO[Any, AwsError, List[ImportImageTaskId]] =
      AwsError.unwrapOptionField("importTaskIds", importTaskIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest
  ) extends zio.aws.ec2.model.DescribeImportImageTasksRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val importTaskIds: Optional[List[ImportImageTaskId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importTaskIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ImportImageTaskId(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest
  ): zio.aws.ec2.model.DescribeImportImageTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
