package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterImageRequest(imageId: ImageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeregisterImageRequest = {
    import DeregisterImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeregisterImageRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeregisterImageRequest.ReadOnly =
    zio.aws.ec2.model.DeregisterImageRequest.wrap(buildAwsValue())
}
object DeregisterImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeregisterImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeregisterImageRequest =
      zio.aws.ec2.model.DeregisterImageRequest(imageId)
    def imageId: ImageId
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterImageRequest
  ) extends zio.aws.ec2.model.DeregisterImageRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterImageRequest
  ): zio.aws.ec2.model.DeregisterImageRequest.ReadOnly = new Wrapper(impl)
}
