package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, ClientVpnEndpointId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteClientVpnRouteRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    targetVpcSubnetId: Optional[SubnetId] = Optional.Absent,
    destinationCidrBlock: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest = {
    import DeleteClientVpnRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        targetVpcSubnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.targetVpcSubnetId)
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteClientVpnRouteRequest.ReadOnly =
    zio.aws.ec2.model.DeleteClientVpnRouteRequest.wrap(buildAwsValue())
}
object DeleteClientVpnRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteClientVpnRouteRequest =
      zio.aws.ec2.model.DeleteClientVpnRouteRequest(
        clientVpnEndpointId,
        targetVpcSubnetId.map(value => value),
        destinationCidrBlock
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def targetVpcSubnetId: Optional[SubnetId]
    def destinationCidrBlock: String
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getTargetVpcSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("targetVpcSubnetId", targetVpcSubnetId)
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest
  ) extends zio.aws.ec2.model.DeleteClientVpnRouteRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val targetVpcSubnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetVpcSubnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest
  ): zio.aws.ec2.model.DeleteClientVpnRouteRequest.ReadOnly = new Wrapper(impl)
}
