package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreditSpecificationRequest(cpuCredits: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest = {
    import CreditSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest
      .builder()
      .cpuCredits(cpuCredits: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.CreditSpecificationRequest.wrap(buildAwsValue())
}
object CreditSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreditSpecificationRequest =
      zio.aws.ec2.model.CreditSpecificationRequest(cpuCredits)
    def cpuCredits: String
    def getCpuCredits: ZIO[Any, Nothing, String] = ZIO.succeed(cpuCredits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest
  ) extends zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly {
    override val cpuCredits: String = impl.cpuCredits(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest
  ): zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly = new Wrapper(impl)
}
