package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SpotInstanceRequestId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelSpotInstanceRequestsRequest(
    spotInstanceRequestIds: Iterable[SpotInstanceRequestId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest = {
    import CancelSpotInstanceRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest
      .builder()
      .spotInstanceRequestIds(spotInstanceRequestIds.map { item =>
        SpotInstanceRequestId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelSpotInstanceRequestsRequest.ReadOnly =
    zio.aws.ec2.model.CancelSpotInstanceRequestsRequest.wrap(buildAwsValue())
}
object CancelSpotInstanceRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotInstanceRequestsRequest =
      zio.aws.ec2.model
        .CancelSpotInstanceRequestsRequest(spotInstanceRequestIds)
    def spotInstanceRequestIds: List[SpotInstanceRequestId]
    def getSpotInstanceRequestIds
        : ZIO[Any, Nothing, List[SpotInstanceRequestId]] =
      ZIO.succeed(spotInstanceRequestIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest
  ) extends zio.aws.ec2.model.CancelSpotInstanceRequestsRequest.ReadOnly {
    override val spotInstanceRequestIds: List[SpotInstanceRequestId] = impl
      .spotInstanceRequestIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SpotInstanceRequestId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest
  ): zio.aws.ec2.model.CancelSpotInstanceRequestsRequest.ReadOnly = new Wrapper(
    impl
  )
}
