package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, IpamPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AllocateIpamPoolCidrRequest(
    ipamPoolId: IpamPoolId,
    cidr: Optional[String] = Optional.Absent,
    netmaskLength: Optional[Integer] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    previewNextCidr: Optional[Boolean] = Optional.Absent,
    disallowedCidrs: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest = {
    import AllocateIpamPoolCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(netmaskLength.map(value => value: java.lang.Integer))(
        _.netmaskLength
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(previewNextCidr.map(value => value: java.lang.Boolean))(
        _.previewNextCidr
      )
      .optionallyWith(
        disallowedCidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.disallowedCidrs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateIpamPoolCidrRequest.ReadOnly =
    zio.aws.ec2.model.AllocateIpamPoolCidrRequest.wrap(buildAwsValue())
}
object AllocateIpamPoolCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateIpamPoolCidrRequest =
      zio.aws.ec2.model.AllocateIpamPoolCidrRequest(
        ipamPoolId,
        cidr.map(value => value),
        netmaskLength.map(value => value),
        clientToken.map(value => value),
        description.map(value => value),
        previewNextCidr.map(value => value),
        disallowedCidrs.map(value => value)
      )
    def ipamPoolId: IpamPoolId
    def cidr: Optional[String]
    def netmaskLength: Optional[Integer]
    def clientToken: Optional[String]
    def description: Optional[String]
    def previewNextCidr: Optional[Boolean]
    def disallowedCidrs: Optional[List[String]]
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getNetmaskLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("netmaskLength", netmaskLength)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPreviewNextCidr: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("previewNextCidr", previewNextCidr)
    def getDisallowedCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("disallowedCidrs", disallowedCidrs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest
  ) extends zio.aws.ec2.model.AllocateIpamPoolCidrRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val netmaskLength: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.netmaskLength())
      .map(value => value: Integer)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val previewNextCidr: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.previewNextCidr())
      .map(value => value: Boolean)
    override val disallowedCidrs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.disallowedCidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest
  ): zio.aws.ec2.model.AllocateIpamPoolCidrRequest.ReadOnly = new Wrapper(impl)
}
