package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptTransitGatewayMulticastDomainAssociationsRequest(
    transitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId] =
      Optional.Absent,
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest = {
    import AcceptTransitGatewayMulticastDomainAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value =>
          TransitGatewayMulticastDomainId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest
      .wrap(buildAwsValue())
}
object AcceptTransitGatewayMulticastDomainAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest =
      zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest(
        transitGatewayMulticastDomainId.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        subnetIds.map(value => value)
      )
    def transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId]
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def subnetIds: Optional[List[String]]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, AwsError, TransitGatewayMulticastDomainId] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest
  ) extends zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayMulticastDomainId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(value)
      )
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest
  ): zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
