package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpnEcmpSupportValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue
}
object VpnEcmpSupportValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue
  ): zio.aws.ec2.model.VpnEcmpSupportValue = value match {
    case software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VpnEcmpSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue =
      software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable extends zio.aws.ec2.model.VpnEcmpSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue =
      software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue.ENABLE
  }
  case object disable extends zio.aws.ec2.model.VpnEcmpSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue =
      software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue.DISABLE
  }
}
