package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayPolicyRuleMetaData(
    metaDataKey: Optional[String] = Optional.Absent,
    metaDataValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRuleMetaData = {
    import TransitGatewayPolicyRuleMetaData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRuleMetaData
      .builder()
      .optionallyWith(metaDataKey.map(value => value: java.lang.String))(
        _.metaDataKey
      )
      .optionallyWith(metaDataValue.map(value => value: java.lang.String))(
        _.metaDataValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData.wrap(buildAwsValue())
}
object TransitGatewayPolicyRuleMetaData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRuleMetaData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData =
      zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData(
        metaDataKey.map(value => value),
        metaDataValue.map(value => value)
      )
    def metaDataKey: Optional[String]
    def metaDataValue: Optional[String]
    def getMetaDataKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metaDataKey", metaDataKey)
    def getMetaDataValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metaDataValue", metaDataValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRuleMetaData
  ) extends zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData.ReadOnly {
    override val metaDataKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metaDataKey())
      .map(value => value: String)
    override val metaDataValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metaDataValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRuleMetaData
  ): zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData.ReadOnly = new Wrapper(
    impl
  )
}
