package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TelemetryStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.TelemetryStatus
}
object TelemetryStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TelemetryStatus
  ): zio.aws.ec2.model.TelemetryStatus = value match {
    case software.amazon.awssdk.services.ec2.model.TelemetryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TelemetryStatus.UP =>
      val r = UP
      r
    case software.amazon.awssdk.services.ec2.model.TelemetryStatus.DOWN =>
      val r = DOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.TelemetryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TelemetryStatus =
      software.amazon.awssdk.services.ec2.model.TelemetryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UP extends zio.aws.ec2.model.TelemetryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TelemetryStatus =
      software.amazon.awssdk.services.ec2.model.TelemetryStatus.UP
  }
  case object DOWN extends zio.aws.ec2.model.TelemetryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TelemetryStatus =
      software.amazon.awssdk.services.ec2.model.TelemetryStatus.DOWN
  }
}
