package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import scala.jdk.CollectionConverters._
final case class StoreImageTaskResult(
    amiId: Optional[String] = Optional.Absent,
    taskStartTime: Optional[MillisecondDateTime] = Optional.Absent,
    bucket: Optional[String] = Optional.Absent,
    s3objectKey: Optional[String] = Optional.Absent,
    progressPercentage: Optional[Integer] = Optional.Absent,
    storeTaskState: Optional[String] = Optional.Absent,
    storeTaskFailureReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StoreImageTaskResult = {
    import StoreImageTaskResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StoreImageTaskResult
      .builder()
      .optionallyWith(amiId.map(value => value: java.lang.String))(_.amiId)
      .optionallyWith(
        taskStartTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(s3objectKey.map(value => value: java.lang.String))(
        _.s3objectKey
      )
      .optionallyWith(
        progressPercentage.map(value => value: java.lang.Integer)
      )(_.progressPercentage)
      .optionallyWith(storeTaskState.map(value => value: java.lang.String))(
        _.storeTaskState
      )
      .optionallyWith(
        storeTaskFailureReason.map(value => value: java.lang.String)
      )(_.storeTaskFailureReason)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StoreImageTaskResult.ReadOnly =
    zio.aws.ec2.model.StoreImageTaskResult.wrap(buildAwsValue())
}
object StoreImageTaskResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StoreImageTaskResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StoreImageTaskResult =
      zio.aws.ec2.model.StoreImageTaskResult(
        amiId.map(value => value),
        taskStartTime.map(value => value),
        bucket.map(value => value),
        s3objectKey.map(value => value),
        progressPercentage.map(value => value),
        storeTaskState.map(value => value),
        storeTaskFailureReason.map(value => value)
      )
    def amiId: Optional[String]
    def taskStartTime: Optional[MillisecondDateTime]
    def bucket: Optional[String]
    def s3objectKey: Optional[String]
    def progressPercentage: Optional[Integer]
    def storeTaskState: Optional[String]
    def storeTaskFailureReason: Optional[String]
    def getAmiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getTaskStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getS3objectKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3objectKey", s3objectKey)
    def getProgressPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("progressPercentage", progressPercentage)
    def getStoreTaskState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storeTaskState", storeTaskState)
    def getStoreTaskFailureReason: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("storeTaskFailureReason", storeTaskFailureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StoreImageTaskResult
  ) extends zio.aws.ec2.model.StoreImageTaskResult.ReadOnly {
    override val amiId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.amiId())
      .map(value => value: String)
    override val taskStartTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStartTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val bucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => value: String)
    override val s3objectKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3objectKey())
      .map(value => value: String)
    override val progressPercentage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.progressPercentage())
      .map(value => value: Integer)
    override val storeTaskState: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storeTaskState())
      .map(value => value: String)
    override val storeTaskFailureReason: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeTaskFailureReason())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StoreImageTaskResult
  ): zio.aws.ec2.model.StoreImageTaskResult.ReadOnly = new Wrapper(impl)
}
