package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StaleSecurityGroup(
    description: Optional[String] = Optional.Absent,
    groupId: Optional[String] = Optional.Absent,
    groupName: Optional[String] = Optional.Absent,
    staleIpPermissions: Optional[
      Iterable[zio.aws.ec2.model.StaleIpPermission]
    ] = Optional.Absent,
    staleIpPermissionsEgress: Optional[
      Iterable[zio.aws.ec2.model.StaleIpPermission]
    ] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StaleSecurityGroup = {
    import StaleSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StaleSecurityGroup
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(
        staleIpPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.staleIpPermissions)
      .optionallyWith(
        staleIpPermissionsEgress.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.staleIpPermissionsEgress)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StaleSecurityGroup.ReadOnly =
    zio.aws.ec2.model.StaleSecurityGroup.wrap(buildAwsValue())
}
object StaleSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StaleSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StaleSecurityGroup =
      zio.aws.ec2.model.StaleSecurityGroup(
        description.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        staleIpPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        staleIpPermissionsEgress.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def description: Optional[String]
    def groupId: Optional[String]
    def groupName: Optional[String]
    def staleIpPermissions
        : Optional[List[zio.aws.ec2.model.StaleIpPermission.ReadOnly]]
    def staleIpPermissionsEgress
        : Optional[List[zio.aws.ec2.model.StaleIpPermission.ReadOnly]]
    def vpcId: Optional[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStaleIpPermissions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.StaleIpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("staleIpPermissions", staleIpPermissions)
    def getStaleIpPermissionsEgress: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.StaleIpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "staleIpPermissionsEgress",
      staleIpPermissionsEgress
    )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StaleSecurityGroup
  ) extends zio.aws.ec2.model.StaleSecurityGroup.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val staleIpPermissions
        : Optional[List[zio.aws.ec2.model.StaleIpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.staleIpPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.StaleIpPermission.wrap(item)
          }.toList
        )
    override val staleIpPermissionsEgress
        : Optional[List[zio.aws.ec2.model.StaleIpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.staleIpPermissionsEgress())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.StaleIpPermission.wrap(item)
          }.toList
        )
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StaleSecurityGroup
  ): zio.aws.ec2.model.StaleSecurityGroup.ReadOnly = new Wrapper(impl)
}
