package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Phase2EncryptionAlgorithmsRequestListValue(
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue = {
    import Phase2EncryptionAlgorithmsRequestListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue.ReadOnly =
    zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue
      .wrap(buildAwsValue())
}
object Phase2EncryptionAlgorithmsRequestListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue =
      zio.aws.ec2.model
        .Phase2EncryptionAlgorithmsRequestListValue(value.map(value => value))
    def value: Optional[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue
  ) extends zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue
  ): zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue.ReadOnly =
    new Wrapper(impl)
}
