package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkAclAssociation(
    networkAclAssociationId: Optional[String] = Optional.Absent,
    networkAclId: Optional[String] = Optional.Absent,
    subnetId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkAclAssociation = {
    import NetworkAclAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkAclAssociation
      .builder()
      .optionallyWith(
        networkAclAssociationId.map(value => value: java.lang.String)
      )(_.networkAclAssociationId)
      .optionallyWith(networkAclId.map(value => value: java.lang.String))(
        _.networkAclId
      )
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkAclAssociation.ReadOnly =
    zio.aws.ec2.model.NetworkAclAssociation.wrap(buildAwsValue())
}
object NetworkAclAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkAclAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkAclAssociation =
      zio.aws.ec2.model.NetworkAclAssociation(
        networkAclAssociationId.map(value => value),
        networkAclId.map(value => value),
        subnetId.map(value => value)
      )
    def networkAclAssociationId: Optional[String]
    def networkAclId: Optional[String]
    def subnetId: Optional[String]
    def getNetworkAclAssociationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("networkAclAssociationId", networkAclAssociationId)
    def getNetworkAclId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkAclId", networkAclId)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkAclAssociation
  ) extends zio.aws.ec2.model.NetworkAclAssociation.ReadOnly {
    override val networkAclAssociationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkAclAssociationId())
        .map(value => value: String)
    override val networkAclId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkAclId())
      .map(value => value: String)
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkAclAssociation
  ): zio.aws.ec2.model.NetworkAclAssociation.ReadOnly = new Wrapper(impl)
}
