package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayPrefixListReferenceResponse(
    transitGatewayPrefixListReference: Optional[
      zio.aws.ec2.model.TransitGatewayPrefixListReference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse = {
    import ModifyTransitGatewayPrefixListReferenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse
      .builder()
      .optionallyWith(
        transitGatewayPrefixListReference.map(value => value.buildAwsValue())
      )(_.transitGatewayPrefixListReference)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse
      .wrap(buildAwsValue())
}
object ModifyTransitGatewayPrefixListReferenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse =
      zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse(
        transitGatewayPrefixListReference.map(value => value.asEditable)
      )
    def transitGatewayPrefixListReference
        : Optional[zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly]
    def getTransitGatewayPrefixListReference: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayPrefixListReference",
      transitGatewayPrefixListReference
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse
  ) extends zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.ReadOnly {
    override val transitGatewayPrefixListReference: Optional[
      zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPrefixListReference())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayPrefixListReference.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse
  ): zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.ReadOnly =
    new Wrapper(impl)
}
