package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, LaunchTemplateName}
import scala.jdk.CollectionConverters._
final case class LaunchTemplate(
    launchTemplateId: Optional[String] = Optional.Absent,
    launchTemplateName: Optional[LaunchTemplateName] = Optional.Absent,
    createTime: Optional[DateTime] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    defaultVersionNumber: Optional[Long] = Optional.Absent,
    latestVersionNumber: Optional[Long] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplate = {
    import LaunchTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplate
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(defaultVersionNumber.map(value => value: java.lang.Long))(
        _.defaultVersionNumber
      )
      .optionallyWith(latestVersionNumber.map(value => value: java.lang.Long))(
        _.latestVersionNumber
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplate.ReadOnly =
    zio.aws.ec2.model.LaunchTemplate.wrap(buildAwsValue())
}
object LaunchTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplate =
      zio.aws.ec2.model.LaunchTemplate(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        createTime.map(value => value),
        createdBy.map(value => value),
        defaultVersionNumber.map(value => value),
        latestVersionNumber.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchTemplateId: Optional[String]
    def launchTemplateName: Optional[LaunchTemplateName]
    def createTime: Optional[DateTime]
    def createdBy: Optional[String]
    def defaultVersionNumber: Optional[Long]
    def latestVersionNumber: Optional[Long]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDefaultVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("defaultVersionNumber", defaultVersionNumber)
    def getLatestVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("latestVersionNumber", latestVersionNumber)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplate
  ) extends zio.aws.ec2.model.LaunchTemplate.ReadOnly {
    override val launchTemplateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateId())
      .map(value => value: String)
    override val launchTemplateName: Optional[LaunchTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val createTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val defaultVersionNumber: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultVersionNumber())
      .map(value => value: Long)
    override val latestVersionNumber: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.latestVersionNumber())
      .map(value => value: Long)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplate
  ): zio.aws.ec2.model.LaunchTemplate.ReadOnly = new Wrapper(impl)
}
