package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportInstanceVolumeDetailItem(
    availabilityZone: Optional[String] = Optional.Absent,
    bytesConverted: Optional[Long] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    image: Optional[zio.aws.ec2.model.DiskImageDescription] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    volume: Optional[zio.aws.ec2.model.DiskImageVolumeDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailItem = {
    import ImportInstanceVolumeDetailItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailItem
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(bytesConverted.map(value => value: java.lang.Long))(
        _.bytesConverted
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(image.map(value => value.buildAwsValue()))(_.image)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportInstanceVolumeDetailItem.ReadOnly =
    zio.aws.ec2.model.ImportInstanceVolumeDetailItem.wrap(buildAwsValue())
}
object ImportInstanceVolumeDetailItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportInstanceVolumeDetailItem =
      zio.aws.ec2.model.ImportInstanceVolumeDetailItem(
        availabilityZone.map(value => value),
        bytesConverted.map(value => value),
        description.map(value => value),
        image.map(value => value.asEditable),
        status.map(value => value),
        statusMessage.map(value => value),
        volume.map(value => value.asEditable)
      )
    def availabilityZone: Optional[String]
    def bytesConverted: Optional[Long]
    def description: Optional[String]
    def image: Optional[zio.aws.ec2.model.DiskImageDescription.ReadOnly]
    def status: Optional[String]
    def statusMessage: Optional[String]
    def volume: Optional[zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getBytesConverted: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesConverted", bytesConverted)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImage
        : ZIO[Any, AwsError, zio.aws.ec2.model.DiskImageDescription.ReadOnly] =
      AwsError.unwrapOptionField("image", image)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVolume: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly
    ] = AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailItem
  ) extends zio.aws.ec2.model.ImportInstanceVolumeDetailItem.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val bytesConverted: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesConverted())
      .map(value => value: Long)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val image
        : Optional[zio.aws.ec2.model.DiskImageDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.image())
        .map(value => zio.aws.ec2.model.DiskImageDescription.wrap(value))
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val volume
        : Optional[zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volume())
        .map(value => zio.aws.ec2.model.DiskImageVolumeDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailItem
  ): zio.aws.ec2.model.ImportInstanceVolumeDetailItem.ReadOnly = new Wrapper(
    impl
  )
}
