package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait HttpTokensState {
  def unwrap: software.amazon.awssdk.services.ec2.model.HttpTokensState
}
object HttpTokensState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.HttpTokensState
  ): zio.aws.ec2.model.HttpTokensState = value match {
    case software.amazon.awssdk.services.ec2.model.HttpTokensState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.HttpTokensState.OPTIONAL =>
      val r = optional
      r
    case software.amazon.awssdk.services.ec2.model.HttpTokensState.REQUIRED =>
      val r = required
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.HttpTokensState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HttpTokensState =
      software.amazon.awssdk.services.ec2.model.HttpTokensState.UNKNOWN_TO_SDK_VERSION
  }
  case object optional extends zio.aws.ec2.model.HttpTokensState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HttpTokensState =
      software.amazon.awssdk.services.ec2.model.HttpTokensState.OPTIONAL
  }
  case object required extends zio.aws.ec2.model.HttpTokensState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HttpTokensState =
      software.amazon.awssdk.services.ec2.model.HttpTokensState.REQUIRED
  }
}
