package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FpgaImageAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName
}
object FpgaImageAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName
  ): zio.aws.ec2.model.FpgaImageAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.DESCRIPTION =>
      val r = description
      r
    case software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.NAME =>
      val r = name
      r
    case software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.LOAD_PERMISSION =>
      val r = loadPermission
      r
    case software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.PRODUCT_CODES =>
      val r = productCodes
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FpgaImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName =
      software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object description extends zio.aws.ec2.model.FpgaImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName =
      software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.DESCRIPTION
  }
  case object name extends zio.aws.ec2.model.FpgaImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName =
      software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.NAME
  }
  case object loadPermission extends zio.aws.ec2.model.FpgaImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName =
      software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.LOAD_PERMISSION
  }
  case object productCodes extends zio.aws.ec2.model.FpgaImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName =
      software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName.PRODUCT_CODES
  }
}
