package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait EventCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.EventCode
}
object EventCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.EventCode
  ): zio.aws.ec2.model.EventCode = value match {
    case software.amazon.awssdk.services.ec2.model.EventCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.EventCode.INSTANCE_REBOOT =>
      val r = `instance-reboot`
      r
    case software.amazon.awssdk.services.ec2.model.EventCode.SYSTEM_REBOOT =>
      val r = `system-reboot`
      r
    case software.amazon.awssdk.services.ec2.model.EventCode.SYSTEM_MAINTENANCE =>
      val r = `system-maintenance`
      r
    case software.amazon.awssdk.services.ec2.model.EventCode.INSTANCE_RETIREMENT =>
      val r = `instance-retirement`
      r
    case software.amazon.awssdk.services.ec2.model.EventCode.INSTANCE_STOP =>
      val r = `instance-stop`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.EventCode {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventCode =
      software.amazon.awssdk.services.ec2.model.EventCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `instance-reboot` extends zio.aws.ec2.model.EventCode {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventCode =
      software.amazon.awssdk.services.ec2.model.EventCode.INSTANCE_REBOOT
  }
  case object `system-reboot` extends zio.aws.ec2.model.EventCode {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventCode =
      software.amazon.awssdk.services.ec2.model.EventCode.SYSTEM_REBOOT
  }
  case object `system-maintenance` extends zio.aws.ec2.model.EventCode {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventCode =
      software.amazon.awssdk.services.ec2.model.EventCode.SYSTEM_MAINTENANCE
  }
  case object `instance-retirement` extends zio.aws.ec2.model.EventCode {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventCode =
      software.amazon.awssdk.services.ec2.model.EventCode.INSTANCE_RETIREMENT
  }
  case object `instance-stop` extends zio.aws.ec2.model.EventCode {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EventCode =
      software.amazon.awssdk.services.ec2.model.EventCode.INSTANCE_STOP
  }
}
