package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointServicePermissionsResponse(
    allowedPrincipals: Optional[Iterable[zio.aws.ec2.model.AllowedPrincipal]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse = {
    import DescribeVpcEndpointServicePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse
      .builder()
      .optionallyWith(
        allowedPrincipals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allowedPrincipals)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointServicePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse =
      zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse(
        allowedPrincipals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def allowedPrincipals
        : Optional[List[zio.aws.ec2.model.AllowedPrincipal.ReadOnly]]
    def nextToken: Optional[String]
    def getAllowedPrincipals: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AllowedPrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField("allowedPrincipals", allowedPrincipals)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse
  ) extends zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly {
    override val allowedPrincipals
        : Optional[List[zio.aws.ec2.model.AllowedPrincipal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedPrincipals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AllowedPrincipal.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse
  ): zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
