package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  MillisecondDateTime,
  NetworkInsightsPathId,
  NetworkInsightsAnalysisId,
  NetworkInsightsMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsAnalysesRequest(
    networkInsightsAnalysisIds: Optional[Iterable[NetworkInsightsAnalysisId]] =
      Optional.Absent,
    networkInsightsPathId: Optional[NetworkInsightsPathId] = Optional.Absent,
    analysisStartTime: Optional[MillisecondDateTime] = Optional.Absent,
    analysisEndTime: Optional[MillisecondDateTime] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[NetworkInsightsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest = {
    import DescribeNetworkInsightsAnalysesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest
      .builder()
      .optionallyWith(
        networkInsightsAnalysisIds.map(value =>
          value.map { item =>
            NetworkInsightsAnalysisId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInsightsAnalysisIds)
      .optionallyWith(
        networkInsightsPathId.map(value =>
          NetworkInsightsPathId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathId)
      .optionallyWith(
        analysisStartTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.analysisStartTime)
      .optionallyWith(
        analysisEndTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.analysisEndTime)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          NetworkInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest
      .wrap(buildAwsValue())
}
object DescribeNetworkInsightsAnalysesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest =
      zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest(
        networkInsightsAnalysisIds.map(value => value),
        networkInsightsPathId.map(value => value),
        analysisStartTime.map(value => value),
        analysisEndTime.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkInsightsAnalysisIds: Optional[List[NetworkInsightsAnalysisId]]
    def networkInsightsPathId: Optional[NetworkInsightsPathId]
    def analysisStartTime: Optional[MillisecondDateTime]
    def analysisEndTime: Optional[MillisecondDateTime]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[NetworkInsightsMaxResults]
    def nextToken: Optional[NextToken]
    def getNetworkInsightsAnalysisIds
        : ZIO[Any, AwsError, List[NetworkInsightsAnalysisId]] =
      AwsError.unwrapOptionField(
        "networkInsightsAnalysisIds",
        networkInsightsAnalysisIds
      )
    def getNetworkInsightsPathId: ZIO[Any, AwsError, NetworkInsightsPathId] =
      AwsError.unwrapOptionField("networkInsightsPathId", networkInsightsPathId)
    def getAnalysisStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("analysisStartTime", analysisStartTime)
    def getAnalysisEndTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("analysisEndTime", analysisEndTime)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, NetworkInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest.ReadOnly {
    override val networkInsightsAnalysisIds
        : Optional[List[NetworkInsightsAnalysisId]] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAnalysisIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId(item)
        }.toList
      )
    override val networkInsightsPathId: Optional[NetworkInsightsPathId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsPathId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInsightsPathId(value))
    override val analysisStartTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisStartTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val analysisEndTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisEndTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[NetworkInsightsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.NetworkInsightsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ): zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest.ReadOnly =
    new Wrapper(impl)
}
