package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ExportTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeExportTasksRequest(
    exportTaskIds: Optional[Iterable[ExportTaskId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest = {
    import DescribeExportTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest
      .builder()
      .optionallyWith(
        exportTaskIds.map(value =>
          value.map { item =>
            ExportTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exportTaskIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeExportTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeExportTasksRequest.wrap(buildAwsValue())
}
object DescribeExportTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeExportTasksRequest =
      zio.aws.ec2.model.DescribeExportTasksRequest(
        exportTaskIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def exportTaskIds: Optional[List[ExportTaskId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getExportTaskIds: ZIO[Any, AwsError, List[ExportTaskId]] =
      AwsError.unwrapOptionField("exportTaskIds", exportTaskIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest
  ) extends zio.aws.ec2.model.DescribeExportTasksRequest.ReadOnly {
    override val exportTaskIds: Optional[List[ExportTaskId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportTaskIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ExportTaskId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest
  ): zio.aws.ec2.model.DescribeExportTasksRequest.ReadOnly = new Wrapper(impl)
}
