package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePlacementGroupResponse(
    placementGroup: Optional[zio.aws.ec2.model.PlacementGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse = {
    import CreatePlacementGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse
      .builder()
      .optionallyWith(placementGroup.map(value => value.buildAwsValue()))(
        _.placementGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreatePlacementGroupResponse.ReadOnly =
    zio.aws.ec2.model.CreatePlacementGroupResponse.wrap(buildAwsValue())
}
object CreatePlacementGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreatePlacementGroupResponse =
      zio.aws.ec2.model.CreatePlacementGroupResponse(
        placementGroup.map(value => value.asEditable)
      )
    def placementGroup: Optional[zio.aws.ec2.model.PlacementGroup.ReadOnly]
    def getPlacementGroup
        : ZIO[Any, AwsError, zio.aws.ec2.model.PlacementGroup.ReadOnly] =
      AwsError.unwrapOptionField("placementGroup", placementGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse
  ) extends zio.aws.ec2.model.CreatePlacementGroupResponse.ReadOnly {
    override val placementGroup
        : Optional[zio.aws.ec2.model.PlacementGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementGroup())
        .map(value => zio.aws.ec2.model.PlacementGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse
  ): zio.aws.ec2.model.CreatePlacementGroupResponse.ReadOnly = new Wrapper(impl)
}
