package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{MillisecondDateTime, Integer}
import scala.jdk.CollectionConverters._
final case class CreateCapacityReservationFleetRequest(
    allocationStrategy: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    instanceTypeSpecifications: Iterable[
      zio.aws.ec2.model.ReservationFleetInstanceSpecification
    ],
    tenancy: Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy] =
      Optional.Absent,
    totalTargetCapacity: Integer,
    endDate: Optional[MillisecondDateTime] = Optional.Absent,
    instanceMatchCriteria: Optional[
      zio.aws.ec2.model.FleetInstanceMatchCriteria
    ] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest = {
    import CreateCapacityReservationFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest
      .builder()
      .optionallyWith(allocationStrategy.map(value => value: java.lang.String))(
        _.allocationStrategy
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .instanceTypeSpecifications(instanceTypeSpecifications.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .totalTargetCapacity(totalTargetCapacity: java.lang.Integer)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateCapacityReservationFleetRequest.ReadOnly =
    zio.aws.ec2.model.CreateCapacityReservationFleetRequest
      .wrap(buildAwsValue())
}
object CreateCapacityReservationFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCapacityReservationFleetRequest =
      zio.aws.ec2.model.CreateCapacityReservationFleetRequest(
        allocationStrategy.map(value => value),
        clientToken.map(value => value),
        instanceTypeSpecifications.map { item =>
          item.asEditable
        },
        tenancy.map(value => value),
        totalTargetCapacity,
        endDate.map(value => value),
        instanceMatchCriteria.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allocationStrategy: Optional[String]
    def clientToken: Optional[String]
    def instanceTypeSpecifications
        : List[zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly]
    def tenancy: Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy]
    def totalTargetCapacity: Integer
    def endDate: Optional[MillisecondDateTime]
    def instanceMatchCriteria
        : Optional[zio.aws.ec2.model.FleetInstanceMatchCriteria]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getAllocationStrategy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceTypeSpecifications: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly
    ]] = ZIO.succeed(instanceTypeSpecifications)
    def getTenancy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetCapacityReservationTenancy
    ] = AwsError.unwrapOptionField("tenancy", tenancy)
    def getTotalTargetCapacity: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(totalTargetCapacity)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetInstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest
  ) extends zio.aws.ec2.model.CreateCapacityReservationFleetRequest.ReadOnly {
    override val allocationStrategy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationStrategy())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val instanceTypeSpecifications: List[
      zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly
    ] = impl
      .instanceTypeSpecifications()
      .asScala
      .map { item =>
        zio.aws.ec2.model.ReservationFleetInstanceSpecification.wrap(item)
      }
      .toList
    override val tenancy
        : Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value =>
          zio.aws.ec2.model.FleetCapacityReservationTenancy.wrap(value)
        )
    override val totalTargetCapacity: Integer =
      impl.totalTargetCapacity(): Integer
    override val endDate: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val instanceMatchCriteria
        : Optional[zio.aws.ec2.model.FleetInstanceMatchCriteria] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMatchCriteria())
        .map(value => zio.aws.ec2.model.FleetInstanceMatchCriteria.wrap(value))
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest
  ): zio.aws.ec2.model.CreateCapacityReservationFleetRequest.ReadOnly =
    new Wrapper(impl)
}
