package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectionLogResponseOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    cloudwatchLogGroup: Optional[String] = Optional.Absent,
    cloudwatchLogStream: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConnectionLogResponseOptions = {
    import ConnectionLogResponseOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConnectionLogResponseOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(cloudwatchLogGroup.map(value => value: java.lang.String))(
        _.cloudwatchLogGroup
      )
      .optionallyWith(
        cloudwatchLogStream.map(value => value: java.lang.String)
      )(_.cloudwatchLogStream)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly =
    zio.aws.ec2.model.ConnectionLogResponseOptions.wrap(buildAwsValue())
}
object ConnectionLogResponseOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConnectionLogResponseOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConnectionLogResponseOptions =
      zio.aws.ec2.model.ConnectionLogResponseOptions(
        enabled.map(value => value),
        cloudwatchLogGroup.map(value => value),
        cloudwatchLogStream.map(value => value)
      )
    def enabled: Optional[Boolean]
    def cloudwatchLogGroup: Optional[String]
    def cloudwatchLogStream: Optional[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getCloudwatchLogGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloudwatchLogGroup", cloudwatchLogGroup)
    def getCloudwatchLogStream: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloudwatchLogStream", cloudwatchLogStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConnectionLogResponseOptions
  ) extends zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val cloudwatchLogGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudwatchLogGroup())
      .map(value => value: String)
    override val cloudwatchLogStream: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudwatchLogStream())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConnectionLogResponseOptions
  ): zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly = new Wrapper(impl)
}
