package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientLoginBannerResponseOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    bannerText: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions = {
    import ClientLoginBannerResponseOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(bannerText.map(value => value: java.lang.String))(
        _.bannerText
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly =
    zio.aws.ec2.model.ClientLoginBannerResponseOptions.wrap(buildAwsValue())
}
object ClientLoginBannerResponseOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientLoginBannerResponseOptions =
      zio.aws.ec2.model.ClientLoginBannerResponseOptions(
        enabled.map(value => value),
        bannerText.map(value => value)
      )
    def enabled: Optional[Boolean]
    def bannerText: Optional[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getBannerText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bannerText", bannerText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions
  ) extends zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val bannerText: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bannerText())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions
  ): zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly = new Wrapper(
    impl
  )
}
