package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Address(
    instanceId: Optional[String] = Optional.Absent,
    publicIp: Optional[String] = Optional.Absent,
    allocationId: Optional[String] = Optional.Absent,
    associationId: Optional[String] = Optional.Absent,
    domain: Optional[zio.aws.ec2.model.DomainType] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    networkInterfaceOwnerId: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    publicIpv4Pool: Optional[String] = Optional.Absent,
    networkBorderGroup: Optional[String] = Optional.Absent,
    customerOwnedIp: Optional[String] = Optional.Absent,
    customerOwnedIpv4Pool: Optional[String] = Optional.Absent,
    carrierIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Address = {
    import Address.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Address
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(allocationId.map(value => value: java.lang.String))(
        _.allocationId
      )
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(
        networkInterfaceOwnerId.map(value => value: java.lang.String)
      )(_.networkInterfaceOwnerId)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(publicIpv4Pool.map(value => value: java.lang.String))(
        _.publicIpv4Pool
      )
      .optionallyWith(networkBorderGroup.map(value => value: java.lang.String))(
        _.networkBorderGroup
      )
      .optionallyWith(customerOwnedIp.map(value => value: java.lang.String))(
        _.customerOwnedIp
      )
      .optionallyWith(
        customerOwnedIpv4Pool.map(value => value: java.lang.String)
      )(_.customerOwnedIpv4Pool)
      .optionallyWith(carrierIp.map(value => value: java.lang.String))(
        _.carrierIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Address.ReadOnly =
    zio.aws.ec2.model.Address.wrap(buildAwsValue())
}
object Address {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Address] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Address = zio.aws.ec2.model.Address(
      instanceId.map(value => value),
      publicIp.map(value => value),
      allocationId.map(value => value),
      associationId.map(value => value),
      domain.map(value => value),
      networkInterfaceId.map(value => value),
      networkInterfaceOwnerId.map(value => value),
      privateIpAddress.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      publicIpv4Pool.map(value => value),
      networkBorderGroup.map(value => value),
      customerOwnedIp.map(value => value),
      customerOwnedIpv4Pool.map(value => value),
      carrierIp.map(value => value)
    )
    def instanceId: Optional[String]
    def publicIp: Optional[String]
    def allocationId: Optional[String]
    def associationId: Optional[String]
    def domain: Optional[zio.aws.ec2.model.DomainType]
    def networkInterfaceId: Optional[String]
    def networkInterfaceOwnerId: Optional[String]
    def privateIpAddress: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def publicIpv4Pool: Optional[String]
    def networkBorderGroup: Optional[String]
    def customerOwnedIp: Optional[String]
    def customerOwnedIpv4Pool: Optional[String]
    def carrierIp: Optional[String]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getAllocationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getDomain: ZIO[Any, AwsError, zio.aws.ec2.model.DomainType] =
      AwsError.unwrapOptionField("domain", domain)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkInterfaceOwnerId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("networkInterfaceOwnerId", networkInterfaceOwnerId)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPublicIpv4Pool: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIpv4Pool", publicIpv4Pool)
    def getNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getCustomerOwnedIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIp", customerOwnedIp)
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
    def getCarrierIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("carrierIp", carrierIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Address
  ) extends zio.aws.ec2.model.Address.ReadOnly {
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
    override val allocationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => value: String)
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val domain: Optional[zio.aws.ec2.model.DomainType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.ec2.model.DomainType.wrap(value))
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val networkInterfaceOwnerId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceOwnerId())
        .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val publicIpv4Pool: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIpv4Pool())
      .map(value => value: String)
    override val networkBorderGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkBorderGroup())
      .map(value => value: String)
    override val customerOwnedIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerOwnedIp())
      .map(value => value: String)
    override val customerOwnedIpv4Pool: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerOwnedIpv4Pool())
      .map(value => value: String)
    override val carrierIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.carrierIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Address
  ): zio.aws.ec2.model.Address.ReadOnly = new Wrapper(impl)
}
