package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayAttachmentBgpConfiguration(
    transitGatewayAsn: Optional[Long] = Optional.Absent,
    peerAsn: Optional[Long] = Optional.Absent,
    transitGatewayAddress: Optional[String] = Optional.Absent,
    peerAddress: Optional[String] = Optional.Absent,
    bgpStatus: Optional[zio.aws.ec2.model.BgpStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration = {
    import TransitGatewayAttachmentBgpConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration
      .builder()
      .optionallyWith(transitGatewayAsn.map(value => value: java.lang.Long))(
        _.transitGatewayAsn
      )
      .optionallyWith(peerAsn.map(value => value: java.lang.Long))(_.peerAsn)
      .optionallyWith(
        transitGatewayAddress.map(value => value: java.lang.String)
      )(_.transitGatewayAddress)
      .optionallyWith(peerAddress.map(value => value: java.lang.String))(
        _.peerAddress
      )
      .optionallyWith(bgpStatus.map(value => value.unwrap))(_.bgpStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly =
    zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration
      .wrap(buildAwsValue())
}
object TransitGatewayAttachmentBgpConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration =
      zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration(
        transitGatewayAsn.map(value => value),
        peerAsn.map(value => value),
        transitGatewayAddress.map(value => value),
        peerAddress.map(value => value),
        bgpStatus.map(value => value)
      )
    def transitGatewayAsn: Optional[Long]
    def peerAsn: Optional[Long]
    def transitGatewayAddress: Optional[String]
    def peerAddress: Optional[String]
    def bgpStatus: Optional[zio.aws.ec2.model.BgpStatus]
    def getTransitGatewayAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("transitGatewayAsn", transitGatewayAsn)
    def getPeerAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("peerAsn", peerAsn)
    def getTransitGatewayAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayAddress", transitGatewayAddress)
    def getPeerAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerAddress", peerAddress)
    def getBgpStatus: ZIO[Any, AwsError, zio.aws.ec2.model.BgpStatus] =
      AwsError.unwrapOptionField("bgpStatus", bgpStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration
  ) extends zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly {
    override val transitGatewayAsn: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAsn())
      .map(value => value: Long)
    override val peerAsn: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.peerAsn())
      .map(value => value: Long)
    override val transitGatewayAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAddress())
      .map(value => value: String)
    override val peerAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.peerAddress())
      .map(value => value: String)
    override val bgpStatus: Optional[zio.aws.ec2.model.BgpStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bgpStatus())
        .map(value => zio.aws.ec2.model.BgpStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration
  ): zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly =
    new Wrapper(impl)
}
