package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TerminateInstancesResponse(
    terminatingInstances: Optional[
      Iterable[zio.aws.ec2.model.InstanceStateChange]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse = {
    import TerminateInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse
      .builder()
      .optionallyWith(
        terminatingInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.terminatingInstances)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TerminateInstancesResponse.ReadOnly =
    zio.aws.ec2.model.TerminateInstancesResponse.wrap(buildAwsValue())
}
object TerminateInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TerminateInstancesResponse =
      zio.aws.ec2.model.TerminateInstancesResponse(
        terminatingInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def terminatingInstances
        : Optional[List[zio.aws.ec2.model.InstanceStateChange.ReadOnly]]
    def getTerminatingInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceStateChange.ReadOnly
    ]] =
      AwsError.unwrapOptionField("terminatingInstances", terminatingInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse
  ) extends zio.aws.ec2.model.TerminateInstancesResponse.ReadOnly {
    override val terminatingInstances
        : Optional[List[zio.aws.ec2.model.InstanceStateChange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminatingInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceStateChange.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse
  ): zio.aws.ec2.model.TerminateInstancesResponse.ReadOnly = new Wrapper(impl)
}
