package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TerminateClientVpnConnectionsResponse(
    clientVpnEndpointId: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    connectionStatuses: Optional[
      Iterable[zio.aws.ec2.model.TerminateConnectionStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse = {
    import TerminateClientVpnConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        connectionStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectionStatuses)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.ReadOnly =
    zio.aws.ec2.model.TerminateClientVpnConnectionsResponse
      .wrap(buildAwsValue())
}
object TerminateClientVpnConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TerminateClientVpnConnectionsResponse =
      zio.aws.ec2.model.TerminateClientVpnConnectionsResponse(
        clientVpnEndpointId.map(value => value),
        username.map(value => value),
        connectionStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientVpnEndpointId: Optional[String]
    def username: Optional[String]
    def connectionStatuses
        : Optional[List[zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly]]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getConnectionStatuses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("connectionStatuses", connectionStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse
  ) extends zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.ReadOnly {
    override val clientVpnEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientVpnEndpointId())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val connectionStatuses
        : Optional[List[zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TerminateConnectionStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse
  ): zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
